<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Ticket extends Model 
{

    protected $table = 'tickets';
    public $timestamps = true;

    public function category()
    {
        return $this->belongsTo('TicketCategory');
    }

    public function comments()
    {
        return $this->hasMany('TicketReply');
    }

    public function attachments()
    {
        return $this->hasMany('Attachment', 'model_id');
    }

    public function priorities()
    {
        return $this->hasMany('TicketPriority');
    }

}